/**
 *
 * \file        hprfgw_rfComLog.h
 *
 * \brief       RF communication log functions declarations and definitions
 *
 * \detial      
 * \author      Hazrat Shah	
 *
 * \date        11/24/2006
 * \warning		
 * \note
 * \review	
 *
 */
#ifndef _HPRFGW_RFCOMLOG_H_
	#define _HPRFGW_RFCOMLOG_H_

//#include "datatypes.h"
#include "hprfgw_rfSharedDefs.h"

////////////////////////////////////////////////////////////////////////////////
//	Definitions
////////////////////////////////////////////////////////////////////////////////

//#define	RF_DEVICE_LINK_QUALITY_HYSTERISES			655		//	rf device link quality hysterisas threshold

////////////////////////////////////uid////////////////////////////////////////////
//	Variable prototypes 
////////////////////////////////////////////////////////////////////////////////

//#define	RF_DBG_LOG

#ifdef	RF_DBG_LOG
	//	rf event logger codes
enum	{
	RF_DBG_MCP_TX_PACKET,				//	0
	RF_DBG_MLME_TX_PACKET,				//	1
	RF_DBG_ASP_TX_PACKET,				//	2
	RF_DBG_MCP_RX_PACKET,				//	3
	RF_DBG_MLME_RX_PACKET,				//	4
	RF_DBG_MCP_RX_PACKET_NOT_FORME,		//	5
	RF_DBG_MCP_RX_PACKET_UNKNOWN,		//	6
	RF_DBG_ASP_RX_PACKET,				//	7
	RF_DBG_MCP_RX_CONF_PACKET,			//	8
	RF_DBG_MLME_RX_CONF_PACKET,			//	9 
	RF_DBG_ASP_RX_CONF_PACKET,			//	10
	RF_DBG_MCP_RX_PURGE_CONF_PACKET,	//	11
	RF_DBG_MCP_RETRY_PACKET,			//	12
	RF_DBG_MLME_RETRY_PACKET,			//	13
	RF_DBG_ASP_RETRY_PACKET,			//	14
	RF_DBG_MCP_RESULT_TO_PACKET,		//	15
	RF_DBG_MLME_RESULT_TO_PACKET,		//	16
	RF_DBG_ASP_RESULT_TO_PACKET,		//	17
	RF_DBG_MCP_RX_ANY_PACKET,			//	18
	RF_DBG_MLME_RX_ANY_PACKET,			//	19
	RF_DBG_ASP_RX_ANY_PACKET			//	20
};

	//	rf debug trace buffer
	typedef	struct	{
		UINT8	evcode;
		UINT8	index;
		UINT8	type;
		UINT8	pkttype;
		UINT8	pkt;
		UINT32	pktcnt;
		UINT32	time;
	}	TYPE_RF_DBG_TRACE;	
	#define	RF_DBG_TRACE_MAX_SIZE		2000
	typedef	struct {
		TYPE_RF_DBG_TRACE	RFdbg[RF_DBG_TRACE_MAX_SIZE];	

		UINT32	rfdbgindex;
	}	TYPE_DBG_TXRX_TRACE_REC;
	extern	TYPE_DBG_TXRX_TRACE_REC RFDbgTrace;
#endif

////////////////////////////////////////////////////////////////////////////////
//	Function declaractions	
////////////////////////////////////////////////////////////////////////////////
#define	RF_COMERROR_LOG_INIT_POSTFUNC		0
#define	RF_COMERROR_LOG_INIT_CONFIRMFUNC	1
UINT16	RFComLog_PutRFDeviceMsgError (UINT8 index, UINT8 type, UINT8 subtype, UINT8 req, UINT8 initiator, UINT8 code);
UINT16	RFComLog_GetRFDeviceMsgError (UINT8 index, UINT8 *type, UINT8 *subtype, UINT8 *req, UINT8 *initiator, UINT8 *code);
void	RFComLog_DbgLogInit (void);	
INT32	RFComLog_LogEvent (UINT8 evcode, UINT8 index, UINT8 type, UINT8	pkttype, UINT8	pkt, UINT32	pktcnt, UINT32	time);
INT32	RFComLog_RetreiveEvent (UINT8 *pevcode, UINT8 *pindex, UINT8 *ptype, UINT8	*ppkttype, UINT8 *ppkt, UINT32 *ppktcnt, UINT32 *ptime, UINT32 *ptblindex);
INT32	RFComLog_RetreiveCurrentEventIndex (UINT32 *pindex, UINT32 cnt);

#endif
/**/
